unit UMComboBoxTN;

interface
Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

Type

MComboBoxTN = class(TComboBox)
  private
    procedure Wypelnij_i_ustaw();

public
    procedure  CreateWnd(); override;
    procedure  DestroyWnd(); override;

   // blokujemy wszystkie klawisze
	procedure   MyOnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
	procedure   MyOnKeyKeyPress(Sender: TObject; var Key: Char);

   constructor Create(AOwner: TComponent); override;
   destructor  Destroy; override;
end;

procedure Register();


implementation
{------------------------------------------------------------------------------}
constructor MComboBoxTN.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);

   OnKeyDown  := MyOnKeyDown;
   OnKeyPress := MyOnKeyKeyPress;
end;

procedure MComboBoxTN.CreateWnd();
begin
	inherited;

   Wypelnij_i_ustaw();
end;

destructor MComboBoxTN.Destroy();
begin
	inherited;
end;

procedure MComboBoxTN.DestroyWnd();
begin
   Clear();
	inherited;
end;

procedure MComboBoxTN.MyOnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	if (Key = VK_DOWN) or (Key = VK_UP) then
   begin
   	// OK
   end
   else begin
	  	// blokowanie wszystkich klawiszy
	   Key := 0;
   end;
end;

procedure MComboBoxTN.MyOnKeyKeyPress(Sender: TObject; var Key: Char);
begin
	if (Key = CHR(VK_DOWN)) or (Key = CHR(VK_UP)) then
   begin
   	// OK
   end
   else begin
	  	// blokowanie wszystkich klawiszy
	   Key := CHR(0);
   end;
end;

procedure MComboBoxTN.Wypelnij_i_ustaw();
begin
   Clear();

   Items.Add('Tak');
   Items.Add('Nie');

	Width     := 50;
	ItemIndex := 0;
end;

procedure Register();
begin
  RegisterComponents('MyComponents', [MComboBoxTN]);
end;

end.

